package cn.com.servyou.dto.merged;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author YuJiaqi
 * @version $Id: BaseEmployee.java v 0.1 2018/12/3 下午2:03 YuJiaqi Exp $$
 */
@Data
public class BaseEmployee implements Serializable {

    private static final long serialVersionUID = -5122917560626267756L;

    /**
     * 纳税人识别号
     */
    @JsonProperty(value = "zrrnsrsbh", access = JsonProperty.Access.WRITE_ONLY)
    private String empTaxpayerIdentifier;

    /**
     * 境外纳税人识别号
     */
    @JsonProperty(value = "jwnsrsbh", access = JsonProperty.Access.WRITE_ONLY)
    private String abroadEmpTaxpayerIdentifier;

    /**
     * 自然人登记序号
     */
    @JsonProperty(value = "zrrdjxh", access = JsonProperty.Access.WRITE_ONLY)
    private String empRegistrationNumber;

    /**
     * 自然人档案号
     */
    @JsonProperty(value = "zrrdah", access = JsonProperty.Access.WRITE_ONLY)
    private String empArchivesNumber;

    /**
     * 报送状态
     */
    @JsonProperty(value = "sbzt", access = JsonProperty.Access.WRITE_ONLY)
    private String submissionState;

    /**
     * 人员验证状态
     */
    @JsonProperty(value = "rzzt", access = JsonProperty.Access.WRITE_ONLY)
    private String authenticationState;

    /**
     * 姓名
     */
    @JsonProperty("xm")
    protected String name;

    /**
     * 证照类型名称
     */
    @JsonProperty("zzlx")
    protected String licenseType;

    /**
     * 证照号码
     */
    @JsonProperty("zzhm")
    protected String licenseNumber;

    /**
     * 部门编号
     */
    @JsonProperty("bmbh")
    protected String deptNo;

    /**
     * 员工编号
     */
    @JsonIgnore
    protected Integer employeeId;

}
