package cn.com.servyou.dto.ntax;

import cn.com.servyou.dto.common.SingleCustomerBaseRequest;
import lombok.Data;

import java.util.List;

/**
 * 打印完税证明请求
 *
 * @author sxianl
 * @since 20220331
 */
@Data
public class FdGenerateWithheldVoucherRequestVO extends SingleCustomerBaseRequest {

    /**
     * 开具类型：1(明细),2:(汇总)
     * 如果选择的是明细,pdf显示的就是每一笔缴费的记录,如果选择的是汇总,显示的是该税种所有暑期的汇总数据,如 2019-12-01至 2021-12-31;
     */
    private String kjlx;

    /**
     * 凭证种类: 1(表格式);2(文书式)
     */
    private String pzzl;

    /**
     * 明细
     */
    private List<WithheldVoucherDataDetailVO> wszmmxlb;
}
