package cn.com.servyou.dto.ntax;

import lombok.Data;

import java.util.List;

/**
 * 银行端缴款凭证结果
 *
 * @author wulg
 * @since 20240321
 */
@Data
public class GetBankPaymentVoucherResultVO {

    /**
     * 结果状态
     *
     * @Description 0：处理中，1：成功，2：失败
     */
    private Integer jgzt;

    /**
     * 错误信息
     */
    private String cwxx;

    /**
     * 缴款方式
     * 默认01不对外透出
     * 00：三方协议缴款 01：银行端缴款
     */
    private String jkfs;

    /**
     * 缴款状态：01:成功，02:部分成功，03:失败
     */
    private String jkzt;

    /**
     * 缴款信息
     */
    private PaymentInfoDataVO jkxx;

    /**
     * 银行端缴款凭证列表
     */
    private List<BankPaymentVoucherVO> yhdjkpzlb;
}
