package cn.com.servyou.dto.ntax;

import lombok.Data;

import java.math.BigDecimal;

/**
 * @author rjq
 * @version 20220526
 */
@Data
public class NTaxStateVO {
    /**
     * 增值税应补退税额
     */
    private BigDecimal ybtse;

    /**
     * 增值税申报状态
     * UNFILLED(0, "未填写"),
     * FILLED(1, "已填写"),
     * DECLARING(2, "发送申报中"),
     * DECLARESUCCESS(3, "申报成功"),
     * DECLAREFAILURE(4, "申报失败"),
     * CALCELDECLARE(5, "申报作废中"),
     * EXPORTDECLARE(6, "导出申报中"),
     * PAIDSUCCESS(7, "缴款成功"),
     * UNDECLARED(8, "未申报");
     */
    private Integer sbzt;

    /**
     * 缴款状态
     */
    private Integer jkzt;

    /**
     * 缴款金额
     */
    private BigDecimal jkje;
}
