package cn.com.servyou.dto.ntax;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

/**
 * 已缴款/未缴款信息
 *
 * @author wulg
 * @since 20240321
 */
@Data
public class PaymentPaidInfoDataVO {

    /**
     * 记录id
     */
    @JsonProperty("id")
    private String id;

    /**
     * 登记序号
     */
    @JsonProperty("djxh")
    private String registrationNumber;

    /**
     * 申报状态代码
     */
    @JsonProperty("sbztdm")
    private String declarationStateCode;

    /**
     * 申报状态名称
     */
    @JsonProperty("sbztmc")
    private String declarationStateName;

    /**
     * 缴款状态代码
     */
    @JsonProperty("jkztdm")
    private String paymentStateCode;

    /**
     * 缴款状态名称
     */
    @JsonProperty("jkztmc")
    private String paymentStateName;

    /**
     * 应补退税额
     */
    @JsonProperty("ybtse")
    private String refundTax;

    /**
     * 所属期起
     */
    @JsonProperty("skssqq")
    private String periodStart;

    /**
     * 所属期止
     */
    @JsonProperty("skssqz")
    private String periodEnd;

    /**
     * 申报期限
     */
    @JsonProperty("sbqx")
    private String declarationTerm;

    /**
     * 缴款期限
     */
    @JsonProperty("jkqx")
    private String paymentTerm;

    /**
     * 电子税票号码
     */
    @JsonProperty("dzsphm")
    private String electronicTaxReceiptNumber;

    /**
     * 征收项目代码
     */
    @JsonProperty("zsxmdm")
    @JsonIgnore
    private String imposeProjectCode;

    /**
     * 征收项目名称
     */
    @JsonProperty("zsxmmc")
    private String imposeProjectName;

    /**
     * 征收品目代码
     */
    @JsonProperty("zspmdm")
    @JsonIgnore
    private String imposeItemCode;

    /**
     * 征收品目名称
     */
    @JsonProperty("zspmmc")
    private String imposeItemName;

    /**
     * 已缴税额
     */
    @JsonProperty("yjse")
    private String taxAmount;

    /**
     * 已缴金额
     */
    @JsonProperty("yjje")
    private String paymentAmount;

    /**
     * 应征凭证明细序号
     */
    @JsonProperty("yzpzmxxh")
    private String documentDetailNumber;

    /**
     * 缴款日期
     */
    @JsonProperty("jkrq")
    private String paymentDate;

    /**
     * 申报日期
     */
    @JsonProperty("sbrq")
    private String declarationDate;

    /**
     * 入库日期
     */
    @JsonProperty("rkrq")
    private String warehousingDate;

    /**
     * 凭证序号
     */
    @JsonProperty("pzxh")
    private String certificateSerialNumber;

    /**
     * 纳税人识别号
     */
    @JsonProperty("nsrsbh")
    private String taxNo;

    /**
     * 纳税人名称
     */
    @JsonProperty("nsrmc")
    private String withholdingAgentName;

    /**
     * 征收税务机关代码
     */
    @JsonProperty("zsswjgdm")
    private String authorityCode;
}
