package cn.com.servyou.dto.ntax;


import cn.com.servyou.dto.common.SingleCustomerBaseRequest;
import lombok.Data;

/**
 * 法电-查询完税证明
 *
 * @author wulg
 * @since 20240425
 */
@Data
public class QueryWithheldVoucherRequestVO extends SingleCustomerBaseRequest {

    /**
     * 查询方式: 1:税费(暑)期;2:缴（退）款时间
     */
    private String cxfs;

    /**
     * 查询日期起: 税款所属期起;缴退款时间起,起止不能超过一年
     * 格式：yyyy-MM-dd
     */
    private String cxrqq;

    /**
     * 查询日期止: 税款所属期止;缴退款时间止
     * 格式：yyyy-MM-dd
     */
    private String cxrqz;

    /**
     * 开具类型：1(明细),2:(汇总)
     * 如果选择的是明细,pdf显示的就是每一笔缴费的记录,如果选择的是汇总,显示的是该税种所有暑期的汇总数据,如 2019-12-01至 2021-12-31;
     */
    private String kjlx;

    /**
     * 是否补打标志:Y/N
     * pzzlDm为1时必填
     */
    private String sfbdbz;

    /**
     * 凭证种类: 1(表格式);2(文书式)
     */
    private String pzzl;

    /**
     * 是否电子退税:Y/N
     */
    private String sfdzsrths;
}
