package cn.com.servyou.dto.ntax;

import lombok.Data;

/**
 * 核定文书信息
 *
 * @author rjq
 * @since 20221124
 */
@Data
public class TaxInitialWsxxResultVO {
    /**
     * 税种类别代码
     *
     * @desc 01：货劳  02：服务   03：混征 00未知
     */
    private String szlbdm;

    /**
     * 个体户标志
     *
     * @desc 0非个体户、1个体户 2未知
     */
    private String gthbz;

    /**
     * 起征点
     */
    private String qzd;

    /**
     * 逾期未认定标志
     *
     * @desc 1是 0否 2未知
     */
    private String yqwrdbz;

    /**
     * 应税货物征收率
     *
     * @desc 0.03
     */
    private String yshwynzsl;

    /**
     * 应税服务征收率
     *
     * @desc 0.03
     */
    private String ysfwynzsl;

    /**
     * 双定户标志
     *
     * @desc 1是 0否 2未知
     */
    private String sdhbz;
}
