package cn.com.servyou.dto.ntax;

import lombok.Data;

import java.math.BigDecimal;

/**
 * 完税证明明细数据
 *
 * @author wulg
 * @since 20240425
 */
@Data
public class WithheldVoucherDataDetailVO {

    /**
     * 扣缴金额
     */
    private BigDecimal kjje;

    /**
     * 税款属性代码
     */
    private String sksxdm;

    /**
     * 征收uuid
     */
    private String zsuuid;

    /**
     * 征收项目代码
     */
    private String zsxmdm;

    /**
     * 征收项目名称
     */
    private String zsxmmc;

    /**
     * 征收品目代码
     */
    private String zspmdm;

    /**
     * 征收品目名称
     */
    private String zspmmc;

    /**
     * 税款种类代码
     */
    private String skzldm;

    /**
     * 实缴日期
     */
    private String sjrq;

    /**
     * 税款所属期起
     * yyyy-MM-dd
     */
    private String skssqq;

    /**
     * 税款所属期止
     * yyyy-MM-dd
     */
    private String skssqz;

    /**
     * 实缴金额
     */
    private BigDecimal sjje;

    /**
     * 征收税务机关代码
     */
    private String zsjgdm;

    /**
     * 电子税票号码
     */
    private String dzsphm;

    /**
     * 税款所属税务机关代码
     */
    private String skssswjgdm;

    /**
     * 税票uuid
     */
    private String spuuid;

    /**
     * 扣缴日期
     */
    private String kjrq;

    /**
     * 税款缴纳方式
     */
    private String skjnfsdm;

    /**
     * 录入人代码
     */
    private String lrrdm;

    /**
     * 收款国库代码
     */
    private String skgkdm;

    /**
     * 应征凭证序号
     */
    private String yzpzxh;

    /**
     * 开具税收完税证明原因
     */
    private String kjsswszmyy;

    /**
     * 银行行别代码
     */
    private String yhhbdm;

    /**
     * 银行营业网点代码
     */
    private String yhyywddm;

    /**
     * 税源编号
     */
    private String sybm;

    /**
     * 是否电子退税:Y/N
     */
    private String sfdzsrths;

    /**
     * 备注
     */
    private String bz;
}
