package cn.com.servyou.dto.ntax;

import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 完税证明数据
 *
 * @author wulg
 * @since 20240425
 */
@Data
public class WithheldVoucherDataVO {

    /**
     * 电子税票号码
     */
    private String dzsphm;

    /**
     * 税款所属期起
     * yyyy-MM-dd
     */
    private String skssqq;

    /**
     * 税款所属期止
     * yyyy-MM-dd
     */
    private String skssqz;

    /**
     * 实缴日期
     */
    private String sjrq;

    /**
     * 实缴金额
     */
    private BigDecimal sjje;

    /**
     * 开具税收完税证明原因
     */
    private String kjsswszmyy;

    /**
     * 完税证明明细列表
     */
    private List<WithheldVoucherDataDetailVO> wszmmxlb;
}
