/**
 * cn.com.servyou.com.cn Inc.
 * Copyright (c) 1999-2019 All Rights Reserved.
 */

package cn.com.servyou.dto.payment;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

/**
 * @author xingting
 * @version 2019/1/7 20:22 xingting
 */
@Data
public class Agreement {

    /**
     * 三方协议号
     */
    @JsonProperty("sfxyh")
    private String agreementNumber;

    /**
     * 税款所属税务机构代码.
     */
    @JsonProperty("zgswjgdm")
    private String responsibleAuthorityCode;

    /**
     * 银行行别代码.
     */
    @JsonProperty("yhhbdm")
    private String bankCode;

    /**
     * 银行行别名称.
     */
    @JsonProperty("yhhbmc")
    private String bankName;

    /**
     * 银行营业网点代码.
     */
    @JsonProperty("yywddm")
    private String bankBranchCode;

    /**
     * 银行营业网点名称.
     */
    @JsonProperty("yywdmc")
    private String bankBranchName;

    /**
     * 清算行行号.
     */
    @JsonProperty("qshhh")
    private String clearingBankCode;

    /**
     * 开户行行号.
     */
    @JsonProperty("khhhh")
    private String accountBankCode;

    /**
     * 缴款帐号.
     */
    @JsonProperty("jkzh")
    private String withholdingAccountNumber;

    /**
     * 缴款账户名称.
     */
    @JsonProperty("jkmc")
    private String withholdingAccountName;

    /**
     * 三方协议状态代码
     */
    @JsonProperty("sfxyztdm")
    private String agreementState;

    /**
     * 三方协议验证信息.
     */
    @JsonProperty("sfxyyzxx")
    private String verificationInfomration;

    /**
     * 三方协议验证通过日期.
     */
    @JsonProperty("sfxyyztgrq")
    private String verificationDate;

    /**
     * 批扣标志.
     */
    @JsonProperty("pkbz")
    private String batchWithholdingFlag;

    /**
     * 数据同步时间.
     */
    @JsonProperty("sjtbsj")
    private String dataSyncTime;

    /**
     * 有效状态
     *
     * @Description 0-有效，1-失效.
     */
    @JsonProperty("yxzt")
    private String validStatus;
}
