/**
 * cn.com.servyou.com.cn Inc.
 * Copyright (c) 1999-2019 All Rights Reserved.
 */

package cn.com.servyou.dto.payment;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

/**
 * 欠费反馈信息实体类
 *
 * @author xingting
 * @version 2019/1/8 21:44 xingting
 */
@Data
public class ArrearageFeedback {

    /**
     * 综合所得欠费信息
     */
    @JsonProperty("zhsdqf")
    private ArrearageResult complexIncomeArrearage;

    /**
     * 分类所得欠费信息
     */
    @JsonProperty("flsdqf")
    private ArrearageResult classificationIncomeArrearage;

    /**
     * 非居民所得欠费信息
     */
    @JsonProperty("fjmsdqf")
    private ArrearageResult nonResidentsIncomeArrearage;

    /**
     * 限售股所得欠费信息
     */
    @JsonProperty("xsgsdqf")
    private ArrearageResult restrictedStockIncomeArrearage;
}
