/**
 * cn.com.servyou.com.cn Inc.
 * Copyright (c) 1999-2019 All Rights Reserved.
 */

package cn.com.servyou.dto.payment;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author xingting
 * @version 2019/1/8 21:51 xingting
 */
@Data
public class ArrearageResult {

    /**
     * 欠费查询状态
     */
    @JsonProperty("qfzt")
    private Integer state;

    /**
     * 欠费查询失败原因
     */
    @JsonProperty("sbyy")
    private String resaon;

    /**
     * 滞纳金
     */
    @JsonProperty("znje")
    private BigDecimal lateFee;

    /**
     * 应补(退)税额
     */
    @JsonProperty("ybtse")
    private BigDecimal dueOverPayment;

    /**
     * 申报状态
     */
    @JsonProperty("sbzt")
    private String declarationState;

    /**
     * 税款所属税务机关代码
     */
    @JsonProperty("zgswjgdm")
    private String taxAffiliationAuthorityCode;
}
