package cn.com.servyou.dto.payment;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author ranjh
 * @since
 */
@Data
public class ArrearageResultDetailV2VO {

    /**
     * 申报所得类型
     */
    @JsonProperty("sbsdlx")
    private String declarationType;

    /**
     * 税款所属期起
     * yyyy-MM-dd
     */
    @JsonProperty("skssqq")
    private String periodStart;

    /**
     * 税款所属期止
     * yyyy-MM-dd
     */
    @JsonProperty("skssqz")
    private String periodEnd;

    /**
     * 应补退税额
     */
    @JsonProperty("ybtse")
    private BigDecimal refundTax;

    /**
     * 欠税金额
     * 应补退余额
     */
    @JsonProperty("qsje")
    private BigDecimal dueOverPayment;

    /**
     * 滞纳金额
     */
    @JsonProperty("znje")
    private BigDecimal lateFee;

    /**
     * 缴款期限
     * yyyy-MM-dd
     */
    @JsonProperty("jkqx")
    private String withholdingDeadline;

    /**
     * 收款国库
     */
    @JsonProperty("skgk")
    private String gatheringExchequerName;

    /**
     * 税款所属税务机关名称
     */
    @JsonProperty("skssswjg")
    private String taxAffiliationAuthorityName;

    /**
     * 登记注册类型
     */
    @JsonProperty("djzclx")
    private String registrationTypeName;
}
