package cn.com.servyou.dto.payment;

import cn.com.servyou.dto.BaseRequest;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 撤销手续费退税确认入参
 *
 * @author wzh
 * @since 20200423
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class CommissionCancelRequest extends BaseRequest {

    /**
     * 结报单序号
     */
    @JsonProperty("jbdxh")
    private String taxTicketNumber;

    /**
     * 手续费退税序号
     */
    @JsonProperty("sxftsxh")
    private String commissionNumber;

    /**
     * 税款所属税务机关代码
     */
    @JsonProperty("skssjg")
    private String taxAffiliationAuthorityCode;
}
