package cn.com.servyou.dto.payment;

import cn.com.servyou.dto.BaseRequest;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 手续费退税确认request
 *
 * @author wzh
 * @since 20200323
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class CommissionConfirmRequest extends BaseRequest {

    /**
     * 结报单序号
     */
    @JsonProperty("jbdxh")
    private String taxTicketNumber;

    /**
     * 手续费退税序号
     */
    @JsonProperty("sxftsxh")
    private String commissionNumber;

    /**
     * 税款所属税务机关代码
     */
    @JsonProperty("skssjg")
    private String taxAffiliationAuthorityCode;

    /**
     * 银行行别代码
     */
    @JsonProperty("yhhbdm")
    private String bankCode;

    /**
     * 银行营业网点代码(自然人可空，企业必录)
     */
    @JsonProperty("yhwddm")
    private String bankBranchCode;

    /**
     * 银行账号
     */
    @JsonProperty("yhzh")
    private String bankAccount;

    /**
     * 开户银行省份(自然人必录，企业可空)
     */
    @JsonProperty("khyhsf")
    private String depositBankProvince;

    /**
     * 隐藏电子税票号码列表
     */
    @JsonProperty("ycdzsphmlb")
    private List<String> hideTaxReceiptNumberList;

}
