package cn.com.servyou.dto.payment;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

/**
 * 手续费退税信息
 *
 * @author wzh
 * @since 20200223
 */
@Data
public class CommissionVO {

    /**
     * 企业名称
     */
    @JsonProperty("qymc")
    private String name;

    /**
     * 税号
     */
    @JsonProperty("nsrsbh")
    private String taxNo;

    /**
     * 结报单列表
     */
    @JsonProperty("jbdlb")
    private List<TaxTicketVO> taxTicketList;

    /**
     * 银行账户信息
     */
    @JsonProperty("yhzhlb")
    private List<CommissionBankAccountVO> bankAccountList;
}
