package cn.com.servyou.dto.payment;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 手续费结报单对象
 *
 * @author xrui
 * @since 20201224
 */
@Data
public class TaxTicketVO implements Serializable {

    /**
     * 结报单编号
     */
    @JsonProperty("jbdxh")
    private String taxTicketNumber;

    /**
     * 结报日期起
     */
    @JsonProperty("jbrqq")
    private String reimbursementDateStart;

    /**
     * 结报日期止
     */
    @JsonProperty("jbrqz")
    private String reimbursementDateEnd;

    /**
     * 确认标志状态 Y-已确认 N-未确认
     */
    @JsonProperty("qrbszt")
    private String confirmStatus;

    /**
     * 税款所属税务机关代码
     */
    @JsonProperty("skssjgdm")
    private String taxAffiliationAuthorityCode;

    /**
     * 申请状态代码
     */
    @JsonProperty("sqztdm")
    private String applyStateCode;

    /**
     * 手续费退税序号
     */
    @JsonProperty("sxftsxh")
    private String commissionNumber;

    /**
     * 票证种类名称
     */
    @JsonProperty("pzzlmc")
    private String ticketTypeName;

    /**
     * 退付手续费分户核对集合
     */
    @JsonProperty("hdqclb")
    private List<VerifyDeclarationVO> verifyDeclarationList;

    /**
     * 退付手续费金额
     */
    @JsonProperty("tfsxfje")
    private BigDecimal refundAmount;

    /**
     * 税款总金额
     */
    @JsonProperty("skzje")
    private BigDecimal actualTaxAmount;
}
