package cn.com.servyou.dto.payment;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 手续费分户核对清册
 *
 * @author wzh
 * @since 20200323
 */
@Data
public class VerifyDeclarationVO implements Serializable {

    /**
     * 电子税票号码
     */
    @JsonProperty("dzsphm")
    private String taxReceiptNumber;

    /**
     * 隐藏电子税票号码
     */
    @JsonProperty("ycdzsph")
    private String hideTaxReceiptNumber;

    /**
     * 税款所属期止
     */
    @JsonProperty("skssqz")
    private String periodEnd;

    /**
     * 税款所属税务机关代码
     */
    @JsonProperty("skssjgdm")
    private String taxAffiliationAuthorityCode;

    /**
     * 税款所属税务机关名称
     */
    @JsonProperty("skssjgmc")
    private String taxAffiliationAuthorityName;

    /**
     * 征收项目代码
     */
    @JsonProperty("zsxmdm")
    private String imposeItemCode;

    /**
     * 征收项目名称
     */
    @JsonProperty("zsxmmc")
    private String imposeItemName;

    /**
     * 征收品目代码
     */
    @JsonProperty("zspmdm")
    private String imposeTypeCode;

    /**
     * 征收品目名称
     */
    @JsonProperty("zspmmc")
    private String imposeTypeName;

    /**
     * 原票证种类代码
     */
    @JsonProperty("ypzzldm")
    private String ticketTypeCode;

    /**
     * 原票证种类名称
     */
    @JsonProperty("ypzzlmc")
    private String ticketTypeName;

    /**
     * 实缴（退）金额
     */
    @JsonProperty("sjtje")
    private BigDecimal actualTax;

    /**
     * 入库日期
     */
    @JsonProperty("rkrq")
    private String warehousingDate;

    /**
     * 主管税务机关代码
     */
    @JsonProperty("zgswjgdm")
    private String responsibleAuthorityCode;

    /**
     * 主管税务机关名称
     */
    @JsonProperty("zgsujgmc")
    private String responsibleAuthorityName;

    /**
     * 主管税务所（科、分局）代码
     */
    @JsonProperty("zgswsdm")
    private String responsibleAuthorityBranchCode;

    /**
     * 主管税务所（科、分局）名称
     */
    @JsonProperty("zgswsmc")
    private String responsibleAuthorityBranchName;

    /**
     * 是否结报 Y-已结报 N-未结报
     */
    @JsonProperty("sfjb")
    private String reimbursementStatus;

    /**
     * 是否退付 Y-已退付 N-未退付
     */
    @JsonProperty("sftf")
    private String refundStatus;
}
