package cn.com.servyou.dto.payment;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

/**
 * 完税证明对象
 *
 * @author zhouww
 * @since 20191226
 */
@Data
public class WithheldVoucherResult {

    /**
     * 综合所得完税证明
     */
    @JsonProperty("zhsd")
    private WithheldVoucherDetailResult complexWithheldVoucherResult;

    /**
     * 分类所得完税证明
     */
    @JsonProperty("flsd")
    private WithheldVoucherDetailResult classificationWithheldVoucherResult;

    /**
     * 非居民所得完税证明
     */
    @JsonProperty("fjmsd")
    private WithheldVoucherDetailResult nonResidentsWithheldVoucherResult;

    /**
     * 滞纳金完税证明
     */
    @JsonProperty("znj")
    private WithheldVoucherDetailResult lateFeeWithheldVoucherResult;
}
