/**
 * cn.com.servyou.com.cn Inc.
 * Copyright (c) 1999-2019 All Rights Reserved.
 */

package cn.com.servyou.dto.payment;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

/**
 * 缴款反馈
 *
 * @author xingting
 * @version 2019/1/9 14:32 xingting
 */
@Data
public class WithholdingFeedback {

    /**
     * 综合所得缴款反馈
     */
    @JsonProperty("zhsdjk")
    private WithholdingResult complexIncomeWithholding;

    /**
     * 分类所得缴款反馈
     */
    @JsonProperty("flsdjk")
    private WithholdingResult classificationIncomeWithholding;

    /**
     * 非居民所得缴款反馈
     */
    @JsonProperty("fjmsdjk")
    private WithholdingResult nonResidentsIncomeWithholding;
}
