/**
 * cn.com.servyou.com.cn Inc.
 * Copyright (c) 1999-2019 All Rights Reserved.
 */

package cn.com.servyou.dto.payment;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

/**
 * 缴款请求反馈
 *
 * @author xingting
 * @since 201919
 */
@Data
public class WithholdingResult {

    /**
     * 扣款请求状态
     */
    @JsonProperty("jkzt")
    private Integer state;

    /**
     * 申报状态
     */
    @JsonProperty("sbzt")
    private String declarationState;

    /**
     * 扣款请求失败原因
     */
    @JsonProperty("jksbyy")
    private String reason;

    /**
     * 电子税票号码
     */
    @JsonProperty("dzsphm")
    private String taxReceiptNumber;

    /**
     * 扣款返回明细列表
     */
    @JsonProperty("kkfhlb")
    private List<WithholdingResultDetailInfo> withholdingDetailInfoList;
}
