/**
 * cn.com.servyou.com.cn Inc.
 * Copyright (c) 1999-2019 All Rights Reserved.
 */

package cn.com.servyou.dto.payment;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 缴款信息
 *
 * @author xingting
 * @version 2019/1/9 14:32 xingting
 */
@Data
public class WithholdingResultDetailInfo {

    /**
     * 扣款返回代码
     */
    @JsonProperty("kkfhDm")
    private String withholdCode;

    /**
     * 扣款返回名称
     */
    @JsonProperty("kkfhmc")
    private String withholdName;

    /**
     * 实缴税额
     */
    @JsonProperty("sjse")
    private BigDecimal actualTax;

}
