package cn.com.servyou.dto.payment;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

/**
 * 缴款凭证
 *
 * @author zhouww
 * @since 20191226
 */
@Data
public class WithholdingVoucherResult {

    /**
     * 缴款凭证序号
     */
    @JsonProperty("jkpzxh")
    private String taxReceiptNumber;

    /**
     * 首次打印时间
     */
    @JsonProperty("dysj")
    private String firstPrintDate;

    /**
     * 纳税人识别号
     */
    @JsonProperty("nsrsbh")
    private String taxpayerIdentifier;

    /**
     * 纳税人名称
     */
    @JsonProperty("nsrxm")
    private String withholdingAgentName;

    /**
     * 税务机关代码
     */
    @JsonProperty("swjgdm")
    private String taxAuthorityCode;

    /**
     * 税务机关名称
     */
    @JsonProperty("swjgmc")
    private String taxAuthorityName;

    /**
     * 税款缴款日期
     */
    @JsonProperty("xjrq")
    private String withholdingDeadline;

    /**
     * 金额合计（小写）
     */
    @JsonProperty("xxjehj")
    private String actualTax;

    /**
     * 金额合计（大写）
      */
    @JsonProperty("dxjehj")
    private String actualTaxUpperCase;

    /**
     * 备注
     */
    @JsonProperty("bz")
    private String remark;

    /**
     * 打印次数
     */
    @JsonProperty("dycs")
    private String printCount;

    /**
     * 缴款凭证明细
     */
    @JsonProperty("jkpzmxlb")
    private List<WithholdingVoucherDetailResult> withholdingVoucherDetailResultList;

    /**
     * 反馈状态
     */
    @JsonProperty("fkzt")
    private String state;

    /**
     * 反馈描述
     */
    @JsonProperty("fkms")
    private String desc;
}