package cn.com.servyou.dto.poi;


import lombok.Data;

import java.math.BigDecimal;

/**
 * @author ranjh
 * @since 20220825
 */
@Data
public class DetailCompanyEmployeeVO {

    /**
     * 姓名
     */
    protected String xm;

    /**
     * 证件类型名称
     */
    protected String zzlx;

    /**
     * 证件号码
     */
    protected String zzhm;

    /**
     * 部门编号
     */
    protected String bmbh;

    /**
     * 是否残疾名称
     */
    private String sfcjmc;

    /**
     * 是否烈属名称
     */
    private String sflsmc;

    /**
     * 是否孤老名称
     */
    private String sfglmc;

    /**
     * 学历名称
     */
    private String xlmc;

    /**
     * 职务名称
     */
    private String zwmc;

    /**
     * 工号
     */
    private String gh;

    /**
     * 所属期
     */
    private String skssq;

    /**
     * 手机号码
     *
     * @Description 11位手机号码
     */
    private String lxdh;

    /**
     * 人员状态
     *
     * @Description 默认为正常，可选择正常/非正常
     */
    private String nsrzt;

    /**
     * 是否雇员
     *
     * @Description 可选择雇员、保险营销员、证券经纪人、其他、实习学生（全日制学历教育）
     */
    private String sfgy;

    /**
     * 入职年度就业情况
     *
     * @Description 当雇员、保险营销员、证券经纪人时可选择：当年首次入职学生、当年首次入职其他人员。其他情况下填写默认为空
     */
    private String rzndjyqk;

    /**
     * 受雇日期
     *
     * @Description 格式:YYYY-MM-DD,不能大于当前时间任职受雇类型选择:雇员、保险营销员、证券经纪人、实习学生（全日制学历教育）时必录
     */
    private String rzsgrq;

    /**
     * 性别
     */
    private String xb;

    /**
     * 出生日期
     *
     * @Description YYYY-MM-DD 需要和身份证上保持一致
     */
    private String csny;

    /**
     * 国籍
     *
     * @Description 见国籍字典
     */
    private String gj;

    /**
     * 人员地区
     *
     * @Description 境内/境外
     */
    private String rydq;

    /**
     * 离职日期
     *
     * @Description 格式：YYYY-MM-DD,不能大于当前时间，离职日期不能大于入职日期 人员状态非正常时必填 注：清空离职时间传入空字符串，不能是null
     */
    private String lzrq;

    /**
     * 个人投资总额
     *
     * @Description 当为股东投资者时必填，投资额大于
     */
    private BigDecimal grgbze;

    /**
     * 个人投资比例
     *
     * @Description 投资额填写时必填，范围为0~100，不包含0
     */
    private BigDecimal grgbbl;

    /**
     * 是否残疾
     *
     * @Description 默认为否，可选择是/否
     */
    private String sfcj;

    /**
     * 是否烈属
     *
     * @Description 默认为否，可选择是/否
     */
    private String sfls;

    /**
     * 是否孤老
     *
     * @Description 默认为否，可选择是/否
     */
    private String sfgl;

    /**
     * 残疾证号
     *
     * @Description 当为残疾时必填
     */
    private String cjzh;

    /**
     * 烈属证号
     *
     * @Description 当为烈属时必填
     */
    private String lszh;

    /**
     * 电子邮箱
     */
    private String dzyx;

    /**
     * 学历
     *
     * @Description 默认为空，大学本科以下 大学本科 研究生
     */
    private String xl;

    /**
     * 职务
     *
     * @Description 高层 普通
     */
    private String zw;

    /**
     * 开户银行省份(名字)
     *
     * @Description 见开户银行省份字典
     */
    private String khyhsfmz;

    /**
     * 开户银行
     *
     * @Description 见银行字典
     */
    private String khyh;

    /**
     * 银行账号
     */
    private String yhzh;

    /**
     * 居住省份
     */
    private String lxdz_sheng;

    /**
     * 居住城市
     */
    private String lxdz_shi;

    /**
     * 居住区县
     */
    private String lxdz_qx;

    /**
     * 居住街道
     */
    private String lxdz_jd;

    /**
     * 居住详细地址
     */
    private String lxdz;

    /**
     * 户籍省份
     */
    private String hjszd_sheng;

    /**
     * 户籍城市
     */
    private String hjszd_shi;

    /**
     * 户籍区县
     */
    private String hjszd_qx;

    /**
     * 户籍街道
     */
    private String hjszd_jd;

    /**
     * 户籍详细地址
     */
    private String hjszd_xxdz;

    /**
     * 备注
     */
    private String bz;

    //境外人员字段

    /**
     * 出生地
     *
     * @Description 外籍人员必填，填写出生地国家（地区）
     */
    private String csd;

    /**
     * 首次入境时间
     *
     * @Description 证件类型为港澳居民来往内地通行证、港澳居民居住证、台湾居民来往大陆通行证、
     * 台湾居民居住证、外国护照、外国人永久居留身份证、外国人来华工作许可证A、外国人来华工作许可证B、
     * 外国人来华工作许可证C时，且任职受雇类型选择雇员时必填，格式YYYY-MM-DD
     */
    private String scrjsj;

    /**
     * 预计离境时间
     *
     * @Description 证件类型为港澳居民来往内地通行证、港澳居民居住证、台湾居民来往大陆通行证、
     * 台湾居民居住证、外国护照、外国人永久居留身份证、外国人来华工作许可证A、外国人来华工作许可证B、
     * 外国人来华工作许可证C时，且任职受雇类型选择雇员时必填，格式YYYY-MM-DD
     */
    private String yjljsj;

    /**
     * 联系地省份
     */
    private String wjrlxdz_sheng;

    /**
     * 联系地城市
     */
    private String wjrlxdz_shi;

    /**
     * 联系地区县
     */
    private String wjrlxdz_qx;

    /**
     * 联系地街道
     */
    private String wjrlxdz_jd;

    /**
     * 联系地详细地址
     */
    private String wjrlxdz_xxdz;

    /**
     * 中文名
     *
     * @Description 证件类型为外国护照、外国人永久居留身份证、外国人工作许可证（A类）、外国人工作许可证（B类）、外国人工作许可证（C类）时不可填写，其他证件类型可填写。如果有填写必须为中文。
     */
    private String xmzw;

    /**
     * 涉税事项
     *
     * @Description 外籍人员必填，多个时用逗号分割  (任职受雇 提供临时劳务 转让财产 从事投资和经营活动 其他)
     */
    private String sssx;

    /**
     * 其他证件号码
     */
    private String qtzzhm;

    /**
     * 其他证件类型
     */
    private String qtzzlx;

    /**
     * 是否扣除减除费用（原是否主单位）
     *
     * @Description 默认为是，可选择是/否
     */
    private String sfzdw;

    /**
     * 人员申报策略
     *
     * @Description 1. 默认逻辑“是”，仅当信息变化时才会报送信息到税局
     * 2. 若企业想要支持人员信息不变化的情况下，也能重新发起报送，覆盖局端信息，可修改传参为“否”
     */
    private String declareEmployeeStrategy;
}
