package cn.com.servyou.dto.poi;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author sunjl
 * @since 20230223
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class PoiAssessmentResultVO extends PoiBaseResultVO {

    /**
     * 税号
     */
    private String nsrsbh;

    /**
     * 月应纳税所得额
     */
    private BigDecimal yynssde;

    /**
     * 纳税期限代码
     */
    private String nsqxdm;

    /**
     * 征收率
     */
    private BigDecimal zsl;

    /**
     * 征收方式
     */
    private String zsfs;

    /**
     * 计税标识
     */
    private String jsbs;

    /**
     * 应税所得率
     */
    private BigDecimal yssdl;

    /**
     * 申报方式
     */
    private String sbfs;

    /**
     * 核定期限起
     */
    private String hdqxq;

    /**
     * 核定期限止
     */
    private String hdqxz;

    /**
     * 所属期Start
     */
    private String skssqq;

    /**
     * 所属期End
     */
    private String skssqz;

    /**
     * 投资者明细
     */
    private List<PoiAssessmentInvestorResultVO> tzzmxlb;
}
