package cn.com.servyou.dto.poi;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
public class PoiCustomerCalculateTaxResultVO extends PoiBaseResultVO {
    /**
     * 税号
     */
    private String nsrsbh;

    /**
     * 登记序号
     */
    private String djxhid;

    /**
     * 税款所属期
     */
    private String skssq;

    /**
     * 申报方式
     */
    private String sbfs;

    /**
     * 收入总额
     */
    private BigDecimal sre;

    /**
     * 成本费用
     */
    private BigDecimal cbfy;

    /**
     * 利润总额
     */
    private BigDecimal lrze;

    /**
     * 弥补以前年度亏损
     */
    private BigDecimal mbyqndks;

    /**
     * 被投资单位经营所得
     */
    private BigDecimal jysd;

    /**
     * 应税所得率
     */
    private BigDecimal yssdl;

    /**
     * 投资者算税明细
     */
    private List<PoiInvestorCalculateTaxResultVO> tzzssmxlb;
}
