package cn.com.servyou.dto.poi;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class PoiCustomerDataDTO implements Serializable {

    private static final long serialVersionUID = 5593904099136262052L;

    /**
     * 税号
     */
    private String nsrsbh;

    /**
     * 登记序号
     */
    private String djxhid;

    /**
     * 税款所属期起
     */
    private String skssqq;

    /**
     * 税款所属期止
     */
    private String skssqz;

    /**
     * 征收方式(1-查账征收,2-核定征收,3-定期定额)
     */
    private String zsfs;

    /**
     * 申报方式(1-据实预缴，2-按上年度应纳税所得额预缴,3-核定应税所得率征收,能准确核算收入总额的，
     * 4-核定应税所得率征收,能准确核算成本费用的，5-税务机关认可的其他方式所得率，6-核定应纳税所得额)
     */
    private String sbfs;

    /**
     * 收入总额
     */
    private BigDecimal sre;

    /**
     * 成本费用
     */
    private BigDecimal cbfy;

    /**
     * 利润总额
     */
    private BigDecimal lrze;

    /**
     * 弥补以前年度亏损
     */
    private BigDecimal mbyqndks;

    /**
     * 被投资单位经营所得
     */
    private BigDecimal btzdwjysd;

    /**
     * 应税所得率,数据库保存的是乘以100之后的结果
     */
    private BigDecimal ynsdl;
}
