package cn.com.servyou.dto.poi;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 生产经营准予扣除的捐赠额附表
 *
 * @author rjq
 * @since 20230223
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class PoiDeductibleDonation extends BaseIncome {
    /**
     * 受赠单位纳税人税号
     */
    private String szdwnsrsbh;

    /**
     * 受增单位名称
     */
    private String szdwmc;

    /**
     * 捐赠凭证号
     */
    private String jzpzh;

    /**
     * 捐赠日期
     */
    private String jzrq;

    /**
     * 捐赠金额
     */
    private BigDecimal jzje;

    /**
     * 扣除比例
     */
    private BigDecimal kcbl;
}
