package cn.com.servyou.dto.poi;

import lombok.Data;

import java.math.BigDecimal;

/**
 * @author sunjl
 * @since 20221222
 */
@Data
public class PoiFspDeclarationBodyVO {

    /**
     * 姓名
     */
    private String xm;

    /**
     * 证件类型
     */
    private String zzlx;

    /**
     * 证件号码
     */
    private String zzhm;

    /**
     * 手机号码
     *
     * @Description 11位手机号码
     */
    private String lxdh;

    /**
     * 分配比例
     */
    private BigDecimal fpbl;

    /**
     * 投资者减除费用
     */
    private BigDecimal tzzjcfy;

    /**
     * 基本养老保险
     */
    private BigDecimal jbylaobxf;

    /**
     * 基本医疗保险
     */
    private BigDecimal jbylbxf;

    /**
     * 失业保险
     */
    private BigDecimal sybx;

    /**
     * 住房公积金
     */
    private BigDecimal zfgjj;

    /**
     * 是否预填专项(附加)扣除
     * 0否 1是
     * 选择“是”自动下载专项(附加)扣除并预填至申报表。
     */
    private Integer sfytzxfjkc;

    /**
     * 是否预填个人养老金
     * 0否 1是
     * 选择“是”自动从局端下载个人养老金金额并预填至申报表，填写“否”则金额传0。
     */
    private Integer sfytgrylj;

    /**
     * 商业健康保险
     */
    private BigDecimal syjkbx;

    /**
     * 税延养老保险
     */
    private BigDecimal syylbx;

    /**
     * 其他扣除
     */
    private BigDecimal qtkc;

    /**
     * 投资抵扣
     */
    private BigDecimal tzdk;

    /**
     * 应纳税所得额
     */
    private BigDecimal ynssde;

    /**
     * 减免税额
     */
    private BigDecimal jmse;

    /**
     * 准予扣除的捐赠额
     */
    private BigDecimal zykcjze;
}
