package cn.com.servyou.dto.poi;

import lombok.Data;

import java.math.BigDecimal;

/**
 * @author sunjl
 * @since 20221222
 */
@Data
public class PoiInvestorCalculateTaxResultVO extends PoiBaseResultVO {

    /**
     * 姓名
     */
    private String xm;

    /**
     * 证件类型
     */
    private String zzlx;

    /**
     * 证件号码
     */
    private String zzhm;

    /**
     * 合伙企业合伙人分配比例
     */
    private BigDecimal fpbl;

    /**
     * 允许扣除费用
     * 允许扣除的个人费用及其他扣除 = 投资者减除费用 + 专项扣除 + 其他
     */
    private BigDecimal yxkcfy;

    /**
     * 投资者减除费用
     */
    private BigDecimal jcfy;

    /**
     * 专项扣除
     */
    private BigDecimal zxkc;

    /**
     * 基本养老保险
     */
    private BigDecimal jbylaobx;

    /**
     * 基本医疗保险
     */
    private BigDecimal jbylbx;

    /**
     * 失业保险
     */
    private BigDecimal sybx;

    /**
     * 住房公积金
     */
    private BigDecimal zfgjj;

    /**
     * 其他
     */
    private BigDecimal qt;

    /**
     * 商业健康保险
     */
    private BigDecimal syjkbx;

    /**
     * 税延养老保险
     */
    private BigDecimal syylbx;

    /**
     * 累计个人养老金
     */
    private BigDecimal ljgrylj;

    /**
     * 其他扣除
     */
    private BigDecimal qtkc;

    /**
     * 准予扣除的捐赠额
     */
    private BigDecimal zykcjze;

    /**
     * 投资抵扣
     */
    private BigDecimal tzdk;

    /**
     * 应纳税所得额
     */
    private BigDecimal ynssde;

    /**
     * 税率(%)
     */
    private BigDecimal sl;

    /**
     * 速算扣除数
     */
    private BigDecimal sskcs;

    /**
     * 应纳税额
     */
    private BigDecimal ynse;

    /**
     * 减免税额
     */
    private BigDecimal jmse;

    /**
     * 已缴税额
     */
    private BigDecimal yjse;

    /**
     * 应补/退税额
     */
    private BigDecimal ybtse;
}
