package cn.com.servyou.dto.poi;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author xrui
 * @since 20200820
 */
@Data
public class PoiInvestorDetailDTO implements Serializable {

    private static final long serialVersionUID = 7209946349282144590L;

    /**
     * 姓名
     */
    private String xm;

    /**
     * 证件类型
     */
    private String zzlx;

    /**
     * 证件号码
     */
    private String zzhm;

    /**
     * 分配比例
     */
    private BigDecimal fpbl;

    /**
     * 允许扣除的税费
     */
    private BigDecimal yxkcsf;

    /**
     * 投资者减除费用
     */
    private BigDecimal jcfy;

    /**
     * 专项扣除合计
     */
    private BigDecimal zxkchj;

    /**
     * 基本养老保险
     */
    private BigDecimal jbylaobxf;

    /**
     * 基本医疗保险
     */
    private BigDecimal jbylbxf;

    /**
     * 失业保险
     */
    private BigDecimal sybx;

    /**
     * 住房公积金
     */
    private BigDecimal zfgjj;

    /**
     * 其他
     */
    private BigDecimal qt;

    /**
     * 商业健康保险
     */
    private BigDecimal syjkbx;

    /**
     * 税延养老保险
     */
    private BigDecimal syylbx;

    /**
     * 其他扣除
     */
    private BigDecimal qtkc;

    /**
     * 应纳税所得额
     */
    private BigDecimal ynssde;

    /**
     * 税率,数据库保存的是乘以100之后的结果
     */
    private BigDecimal sl;

    /**
     * 速算扣除数
     */
    private BigDecimal sskcs;

    /**
     * 应纳税额
     */
    private BigDecimal ynse;

    /**
     * 减免税额
     */
    private BigDecimal jmse;

    /**
     * 已缴税额
     */
    private BigDecimal yjse;

    /**
     * 应补退税额
     */
    private BigDecimal ybtse;

    /**
     * 申报状态
     */
    private String sbzt;

    /**
     * 准予扣除的捐赠额
     */
    private BigDecimal zykcjze;

    /**
     * 反馈内容
     * （申报失败才会赋值）
     */
    private String fknr;
}
