package cn.com.servyou.dto.poi;

import lombok.Data;

import java.math.BigDecimal;

/**
 * @author sunjl
 * @since 20221124
 */
@Data
public class PoiQueryWithholdingResultDetail {

    /**
     * 报表类型
     *
     * @Description 1：A表，2：B表，不填默认为A表
     */
    private String bblx;

    /**
     * 税款所属期起
     */
    private String skssqq;

    /**
     * 税款所属期止
     */
    private String skssqz;

    /**
     * 姓名
     */
    private String xm;

    /**
     * 申报日期(格式 yyyy-MM-dd)
     */
    private String sbrq;

    /**
     * 缴款日期
     * 格式：YYYY-MM-DD
     */
    private String jkrq;

    /**
     * 申报类型
     */
    private String sblx;

    /**
     * 申报类型名称
     */
    private String sblxmc;

    /**
     * 申报状态
     */
    private String sbzt;

    /**
     * 申报状态名称
     */
    private String sbztmc;

    /**
     * 应补（退）税额
     */
    private BigDecimal ybtse;

    /**
     * 实缴税额
     */
    private BigDecimal sjse;

    /**
     * 滞纳金
     */
    private BigDecimal znj;

    /**
     * 缴款方式
     */
    private String jkfs;
}
