package cn.com.servyou.dto.salarydata;

import cn.com.servyou.dto.tax.BaseEmp;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @author ranjh
 * @since 20211125
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class SalaryDataImportComplexIncome extends BaseEmp {

    private static final long serialVersionUID = -540023009353656981L;

    private Integer id;

    /**
     * 所属期
     */
    @JsonProperty("skssq")
    private String period;

    /**
     * 收入额-工资薪金，年终奖金，解除，劳务报酬，稿酬所得
     */
    @JsonProperty("sre")
    private BigDecimal income;

    /**
     * 已完税缴费额
     */
    @JsonProperty("ywsjfe")
    private BigDecimal taxedPayCost;

    /**
     * 全部缴费额
     */
    @JsonProperty("qbjfe")
    private BigDecimal allPayCost;

    /**
     * 是否一次性领取
     * 1-是，0-否
     */
    @JsonProperty("sfycxlq")
    private String onceReceipt;

    /**
     * 分摊月份数
     */
    @JsonProperty("ftyfs")
    private Integer apportionMonths;

    /**
     * 年金领取方式
     */
    @JsonProperty("njlqfs")
    private String annuityReceiptTypeName;

    /**
     * 年金领取原因
     */
    @JsonProperty("njlqyy")
    private String annuityReceiptReasonName;

    /**
     * 免税收入-工资薪金，年终奖金，解除，劳务报酬，稿酬所得
     */
    @JsonProperty("mssd")
    private BigDecimal exemptIncome;

    /**
     * 基本养老保险
     */
    @JsonProperty("jbylaobxf")
    private BigDecimal endowmentInsurance;

    /**
     * 基本医疗保险
     */
    @JsonProperty("jbylbxf")
    private BigDecimal medicalInsurance;

    /**
     * 失业保险
     */
    @JsonProperty("sybxf")
    private BigDecimal unemploymentInsurance;

    /**
     * 住房公积金
     */
    @JsonProperty("zfgjj")
    private BigDecimal houseProvidentFund;

    /**
     * 原始住房公积金 保存用户的传入的住房公积金
     * houseProvidentFund这个字段在某些场景下会改变，所以使用originalHouseProvidentFund这个字段保存原来的公积金
     */
    @JsonProperty("yszfgjj")
    private BigDecimal originalHouseProvidentFund;

    /**
     * 企业年金/职业年金
     */
    @JsonProperty("nj")
    private BigDecimal annuity;

    /**
     * 原始年金 保存用户传入的年金
     * annuity这个字段在某项场景下会改变 需要存储下原始的annuity
     */
    @JsonProperty("ysnj")
    private BigDecimal originalAnnuity;

    /**
     * 商业健康保险
     */
    @JsonProperty("syjkbx")
    private BigDecimal commercialHealthInsurance;

    /**
     * 税延养老保险
     */
    @JsonProperty("syylbx")
    private BigDecimal extensionEndowmentInsurance;

    /**
     * 其他
     */
    @JsonProperty("qt")
    private BigDecimal other;

    /**
     * 减免税额
     */
    @JsonProperty("jmse")
    private BigDecimal taxDeduction;

    /**
     * 备注
     */
    @JsonProperty("bz")
    private String remark;

    /**
     * 专项扣除合计
     * 本期专项扣除合计=基本养老保险费+基本医疗保险费+失业保险费+住房公积金
     */
    @JsonProperty("zxkchj")
    private BigDecimal specDeductionSum;

    /**
     * 专项(附加)扣除合计
     * 本期专项扣除合计=子女教育支出+大病医疗支出+继续教育支出+住房贷款利息支出+住房租金支出+赡养老人支出+婴幼儿照护支出
     */
    @JsonProperty("zxfjkchj")
    private BigDecimal specAttachDeductionSum;

    /**
     * 减除费用
     */
    @JsonProperty("jcfy")
    private BigDecimal deductionAmount;

    /**
     * 其他扣除合计
     */
    @JsonProperty("qtckhj")
    private BigDecimal otherDeductionSum;

    /**
     * 应纳税所得额
     */
    @JsonProperty("ynssde")
    private BigDecimal taxableIncome;

    /**
     * 应纳税额
     */
    @JsonProperty("ynse")
    private BigDecimal payableAmount;

    /**
     * 应扣缴税额
     */
    @JsonProperty("yingkjse")
    private BigDecimal withholdingAmount;

    /**
     * 税率
     */
    @JsonProperty("sl")
    private BigDecimal taxRate;

    /**
     * 速算扣除数
     */
    @JsonProperty("sskcs")
    private BigDecimal quickDeduction;

    /**
     * 所得项目代码
     */
    @JsonProperty("sdxmda")
    private String incomeItemCode;

    /**
     * 所得项目名称-正常工资薪金，全年一次性奖金，解除劳动一次性补偿金，劳务报酬，稿酬所得
     */
    @JsonProperty("sdxm")
    private String incomeItemName;

    /**
     * 应补退税额=累计应扣缴税额-累计已缴税额
     */
    @JsonProperty("ybtse")
    private BigDecimal refundTax;

    /**
     * 累计收入额
     *
     * 本年累计收入=本期所有的工资薪金所得收入之和+往期工资薪金所得收入之和（见税款计算）
     */
    @JsonProperty("ljsre")
    private BigDecimal accumulatedIncome;

    /**
     * 累计免税收入额
     */
    @JsonProperty("ljmssd")
    private BigDecimal accumulatedExemptIncome;

    /**
     * 累计专项扣除额
     */
    @JsonProperty("ljzxkce")
    private BigDecimal accumulatedSpecDeduction;

    /**
     * 累计专项(附加)扣除额
     */
    @JsonProperty("ljzxfjkce")
    private BigDecimal accumulatedSpecAttachDeduction;

    /**
     * 累计其他扣除额
     */
    @JsonProperty("ljqtkce")
    private BigDecimal accumulatedOtherDeduction;

    /**
     * 累计减免税额
     */
    @JsonProperty("ljjmse")
    private BigDecimal accumulatedTaxDeduction;

    /**
     * 累计减除费用额
     */
    @JsonProperty("ljjcfye")
    private BigDecimal accumulatedDeductionAmount;

    /**
     * 累计月减除费用
     */
    @JsonProperty("ljyjcfy")
    private BigDecimal accumulatedMonthDeduction;

    /**
     * 累计应纳税所得额
     */
    @JsonProperty("ljynssde")
    private BigDecimal accumulatedTaxableIncome;

    /**
     * 累计应纳税额
     */
    @JsonProperty("ljynse")
    private BigDecimal accumulatedPayableAmount;

    /**
     * 累计应扣缴税额 = 累计应纳税额 - 累计减免税额
     */
    @JsonProperty("ljyingkjse")
    private BigDecimal accumulatedWithholdingAmount;

    /**
     * 累计子女教育支出
     */
    @JsonProperty("ljznjyzc")
    private BigDecimal accumulatedChildEducation;

    /**
     * 累计大病医疗支出
     */
    @JsonProperty("ljdbylzc")
    private BigDecimal accumulatedSeriousIllness;

    /**
     * 累计继续教育支出
     */
    @JsonProperty("ljjxjyzc")
    private BigDecimal accumulatedContinueEducation;

    /**
     * 累计住房租金支出
     */
    @JsonProperty("ljzfzjzc")
    private BigDecimal accumulatedHouseRent;

    /**
     * 累计房屋贷款支出
     */
    @JsonProperty("ljzfdklxzc")
    private BigDecimal accumulatedHouseLoan;

    /**
     * 累计赡养老人支出
     */
    @JsonProperty("ljsylrzc")
    private BigDecimal accumulatedSupportElder;

    /**
     * 累计3岁以下婴幼儿照护支出
     */
    @JsonProperty("ljyyezhzc")
    private BigDecimal accumulatedBabyCare;

    /**
     * 累计准予扣除的捐赠额
     */
    @JsonProperty("ljzykcjze")
    private BigDecimal accumulatedDeductibleDonation;

    /**
     * 准予扣除的捐赠额
     */
    @JsonProperty("zykcjze")
    private BigDecimal deductibleDonation;

    /**
     * 实际捐赠额
     */
    @JsonProperty("sjjze")
    private BigDecimal actualDonation;

    /**
     * 累计已缴税额
     */
    @JsonProperty("ljykjse")
    private BigDecimal accumulatedPaidAmount;

    /**
     * 本次应扣缴税额
     */
    @JsonProperty("bcykjse")
    private BigDecimal currentWithholdingAmount;

    /**
     * 允许扣除的税费
     */
    @JsonProperty("yxkcsf")
    private BigDecimal taxDeductible;

    /**
     * 月减除费用
     */
    @JsonProperty("yjcfy")
    private BigDecimal monthDeduction;

    /**
     * 税后收入额
     */
    @JsonProperty("shsre")
    private BigDecimal afterTaxIncome;

    /**
     * 原始税额
     */
    @JsonProperty("ysse")
    private BigDecimal originalRefundTax;
}
