package cn.com.servyou.dto.salarydata;

import cn.com.servyou.dto.tax.BaseIncomeRequest;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

/**
 * @author ranjh
 * @since 20211125
 */
@Data
public class SalaryDataImportComplexIncomeRequest extends BaseIncomeRequest {

    /**
     * 正常工资薪金对象
     */
    @JsonProperty("zcgzxj")
    private SalaryDataImportNormalSalarySpecIncome normalSalarySpecIncome;

    /**
     * 全年一次性奖金收入列表
     */
    @JsonProperty("qnycxjjsslb")
    private List<SalaryDataImportComplexIncome> annualOneTimeBonusIncomeList;

    /**
     * 劳务报酬所得列表
     */
    @JsonProperty("lwbclb")
    private List<SalaryDataImportComplexIncome> laborRemunerationIncomeList;

    /**
     * 解除劳动补偿金列表
     */
    @JsonProperty("jcldhtycxbcjlb")
    private List<SalaryDataImportComplexIncome> compensateIncomeList;

    /**
     * 保险营销员佣金收入
     */
    @JsonProperty("bxyxylb")
    private List<SalaryDataImportComplexIncome> insuranceMarketingIncomeList;

    /**
     * 证券经纪人所得
     */
    @JsonProperty("zqjjrlb")
    private List<SalaryDataImportComplexIncome> securitiesBrokerIncomeList;

    /**
     * 其他连续劳务报酬所得
     */
    @JsonProperty("qtlxlwbclb")
    private List<SalaryDataImportComplexIncome> otherContinuationLaborIncomeList;

    /**
     * 企业年金列表
     */
    @JsonProperty("qynjlb")
    private List<SalaryDataImportComplexIncome> enterpriseAnnuityList;

    /**
     * 稿酬所得列表
     */
    @JsonProperty("gcsdlb")
    private List<SalaryDataImportComplexIncome> authorsRemunerationIncomeList;

    /**
     * 批次号列表
     */
    @JsonProperty("pchlb")
    private List<SalaryDataImportBatchNoVO> dataImportBatchNoVOList;
}
