package cn.com.servyou.dto.salarydata;

import cn.com.servyou.dto.tax.BaseEmp;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @author ranjh
 * @since 20211125
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class SalaryDataImportNonResidentsIncome extends BaseEmp {

    private static final long serialVersionUID = -540023009353656981L;

    /**
     * 收入额
     */
    @JsonProperty("sre")
    private BigDecimal income;

    /**
     * 免税收入
     */
    @JsonProperty("mssd")
    private BigDecimal exemptIncome;

    /**
     * 减免税额
     */
    @JsonProperty("jmse")
    private BigDecimal taxDeduction;

    /**
     * 准予扣除的捐赠额
     */
    @JsonProperty("zykcjze")
    private BigDecimal deductibleDonation;

    /**
     * 原始税额
     */
    @JsonProperty("ysse")
    private BigDecimal originalRefundTax;

    /**
     * 其他
     */
    @JsonProperty("qt")
    private BigDecimal other;

    /**
     * 备注
     */
    @JsonProperty("bz")
    private String remark;
}
