package cn.com.servyou.dto.salarydata;

import cn.com.servyou.dto.common.SingleCustomerBaseRequest;
import cn.com.servyou.dto.employee.DeclareEmployeeOption;
import cn.com.servyou.dto.tax.CompanyEmployee;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author ranjh
 * @since 20211125
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class SalaryDataImportRequestVO extends SingleCustomerBaseRequest {

    /**
     * 批次号
     */
    @JsonProperty("pch")
    private Integer batchNo;

    /**
     * 非正常人员导入策略
     */
    @JsonProperty("fzcrydrcl")
    private String abnormalEmployeeOption;

    /**
     * 是否需要人员申报
     *
     * @Description 0：人员不申报 1：人员申报
     */
    @JsonProperty("sfrysb")
    private String declareEmployeeOption = DeclareEmployeeOption.NO.getCode();

    /**
     * 基于平台数据冻结状态增加控制逻辑
     */
    @JsonProperty("jyptsjdjztcl")
    private String checkFreezeStateOption;

    /**
     * 企业员工列表
     */
    @JsonProperty("rylb")
    private List<CompanyEmployee> companyEmployeeList;

    /**
     * 综合所得
     */
    @JsonProperty("zhsd")
    private SalaryDataImportComplexIncomeRequest salaryDataImportComplexIncomeRequest;

    /**
     * 分类所得
     */
    @JsonProperty("flsd")
    private SalaryDataImportClassificationIncomeRequest salaryDataImportClassificationIncomeRequest;

    /**
     * 非居民所得
     */
    @JsonProperty("fjmsd")
    private SalaryDataImportNonResidentsIncomeRequest salaryDataImportNonResidentsIncomeRequest;

}
