package cn.com.servyou.dto.salsrycore;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 年终奖筹划请求人员VO
 *
 * @author yjiah
 * @date 20220526
 */
@Data
public class AnnualBonusPlanEmployeeRequestVO {

    /**
     * 姓名
     */
    @JsonProperty("xm")
    private String name;

    /**
     * 证件类型
     */
    @JsonProperty("zzlx")
    private String licenseTypeName;

    /**
     * 证件号码
     */
    @JsonProperty("zzhm")
    private String licenseNumber;

    /**
     * 全年奖收入额
     */
    @JsonProperty("qnjjsr")
    private BigDecimal annualBonus;

    /**
     * 筹划前当月工资
     */
    @JsonProperty("chqdygz")
    private BigDecimal currentMonthSalary;

    /**
     * 基本养老保险费
     */
    @JsonProperty("jbylaobxf")
    private BigDecimal endowmentInsurance;

    /**
     * 基本医疗保险费
     */
    @JsonProperty("jbylbxf")
    private BigDecimal medicalInsurance;

    /**
     * 失业保险费
     */
    @JsonProperty("sybxf")
    private BigDecimal unemploymentInsurance;

    /**
     * 住房公积金
     */
    @JsonProperty("zfgjj")
    private BigDecimal houseProvidentFund;

    /**
     * 企业（职业）
     * 年金
     */
    @JsonProperty("nj")
    private BigDecimal annuity;

    /**
     * 商业健康保险
     */
    @JsonProperty("syjkbx")
    private BigDecimal healthInsurance;

    /**
     * 税延养老保险
     */
    @JsonProperty("syylbx")
    private BigDecimal extensionInsurance;

    /**
     * 其他
     */
    @JsonProperty("qt")
    private BigDecimal otherDeductions;

    /**
     * 子女教育
     */
    @JsonProperty("znjy")
    private BigDecimal specialChildEducation;

    /**
     * 赡养老人
     */
    @JsonProperty("sylr")
    private BigDecimal specialSupportElder;

    /**
     * 继续教育
     */
    @JsonProperty("jxjy")
    private BigDecimal specialEducation;

    /**
     * 3岁以下婴幼儿照护
     */
    @JsonProperty("yyezh")
    private BigDecimal babyCareExpenditure;

    /**
     * 住房租金
     */
    @JsonProperty("zfzj")
    private BigDecimal specialHouseRent;

    /**
     * 住房贷款利息
     */
    @JsonProperty("zfdkll")
    private BigDecimal specialHouseLoan;

    /**
     * 全年工资及年终奖金收入总额
     */
    @JsonProperty("qnsrze")
    private BigDecimal allIncome;

    /**
     * 专项附加扣除总额
     */
    @JsonProperty("zxfjkcze")
    private BigDecimal annualSpecial;
}
