package cn.com.servyou.dto.salsrycore;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author yjiah
 * @date 20220526
 */
@Data
public class AnnualBonusPlanEmployeeResultVO {

    /**
     * 姓名
     */
    @JsonProperty("xm")
    private String name;

    /**
     * 证件类型
     */
    @JsonProperty("zzlx")
    private String licenseTypeName;

    /**
     * 证件号码
     */
    @JsonProperty("zzhm")
    private String licenseNumber;


    /**
     * 当月工资额
     */
    @JsonProperty("dygze")
    private BigDecimal currentMonthSalary;

    /**
     * 全年收入总额
     */
    @JsonProperty("qnsrze")
    private BigDecimal allIncome;

    /**
     * 专项附加扣除总额
     */
    @JsonProperty("zxfjkcze")
    private BigDecimal annualSpecial;

    /**
     * 筹划前全年奖金
     */
    @JsonProperty("chqqnjj")
    private BigDecimal annualBonusBeforePlan;

    /**
     * 筹划前全年税额
     */
    @JsonProperty("chqqnse")
    private BigDecimal taxBeforePlan;

    /**
     * 筹划前正常工资薪金
     */
    @JsonProperty("chqzcgzxj")
    private BigDecimal annualSalaryBeforePlan;

    /**
     * 筹划后全年奖金
     */
    @JsonProperty("chhqnjj")
    private BigDecimal annualBonusAfterPlan;

    /**
     * 筹划后全年工资额
     */
    @JsonProperty("chhqngze")
    private BigDecimal annualSalaryAfterPlan;

    /**
     * 筹划后全年税额
     */
    @JsonProperty("chhqnse")
    private BigDecimal taxAfterPlan;

    /**
     * 全年节税总额
     */
    @JsonProperty("qnjsze")
    private BigDecimal savingTax;

    /**
     * 申报全年奖金
     */
    @JsonProperty("sbqnjj")
    private BigDecimal declarationAnnualBonus;

    /**
     * 申报全年奖金税额
     */
    @JsonProperty("sbqnjjse")
    private BigDecimal declarationAnnualBonusTax;

    /**
     * 申报当月应发工资
     */
    @JsonProperty("sbdyyfgz")
    private BigDecimal declarationMonthSalary;

    /**
     * 备注
     */
    @JsonProperty("bz")
    private String remark;

}
