package cn.com.servyou.dto.salsrycore;

import cn.com.servyou.dto.BaseRequest;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * 年终奖筹划请求VO
 *
 * @author yjiah
 * @date 20220526
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class AnnualBonusPlanRequestVO extends BaseRequest {

    /**
     * 月最低工资
     */
    @JsonProperty("yzdgz")
    private BigDecimal minMonthlySalary;

    /**
     * 人员列表
     */
    @JsonProperty("rylb")
    private List<AnnualBonusPlanEmployeeRequestVO> employeeRequestVOList;
}
