package cn.com.servyou.dto.tax;

import cn.com.servyou.dto.BaseRequest;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

/**
 * @author ranjh
 * @since 20240524
 */
@Data
public class CalculateFeedbackWithoutRequestIdRequest extends BaseRequest {

    /**
     * 批次号
     */
    @JsonProperty("pch")
    private Integer batchNo;

    /**
     * 薪金类型
     */
    @JsonProperty("xjlx")
    private String salaryType;

    /**
     * 查询类型
     * detail : 明细，按照批次号类
     * summary : 统计，按照汇总查询
     */
    @JsonProperty("cxlx")
    private String queryType;

    /**
     * 证件类型
     */
    @JsonProperty("zzlx")
    private String licenseType;

    /**
     * 证件号码
     */
    @JsonProperty("zzhm")
    private String licenseNumber;

    /**
     * 页码
     */
    @JsonProperty("pageNo")
    private Integer pageNo;

    /**
     * 每页数量
     */
    @JsonProperty("pageSize")
    private Integer pageSize;

    /**
     * 查询平台已冻结状态的数据策略
     *
     *
     * 0：传0或不传，则不校验平台冻结状态
     * 1：传1，则仅查询平台已冻结的数据
     */
    @JsonProperty("sfcxydjsj")
    private String queryFreezeDataFlag;
}
