package cn.com.servyou.dto.tax;

import cn.com.servyou.dto.BaseRequest;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

/**
 * @author zhouww
 * @version 20191016
 */
@Data
public class CalculateIndividualIncomeTaxRequest extends BaseRequest {

    private static final long serialVersionUID = 3942182732271476427L;

    /**
     * 是否校验人员算税状态
     * 应用场景: 如果填写“是”，在多批次算税中会校验当前批次中的人员在之前批次算税中是否存在未拿反馈的请求，如果存在就阻断当前批次算税。
     * 如果不填写或者填写“否”，不校验该逻辑。
     */
    @JsonProperty("sfjyrysszt")
    private String checkEmployeeCalculateState;

    /**
     * 综合所得
     */
    @JsonProperty("zhsd")
    private ComplexIncomeRequest complexIncomeRequest;

    /**
     * 分类所得
     */
    @JsonProperty("flsd")
    private ClassificationIncomeRequest classificationIncomeRequest;

    /**
     * 非居民所得
     */
    @JsonProperty("fjmsd")
    private NonResidentsIncomeRequest nonResidentsIncomeRequest;

    /**
     * 限售股所得
     */
    @JsonProperty("xsgsd")
    private RestrictedStockIncomeRequest restrictedStockIncomeRequest;

}
