package cn.com.servyou.dto.tax;

import cn.com.servyou.dto.BaseRequest;
import cn.com.servyou.dto.employee.EmployeeDeclareFeedback;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

/**
 * @author pez1420@gmail.com
 * @version $Id: CalculateTaxResultRequest.java v 0.1 2018/12/14 1:26 AM pez1420 Exp $$
 */
@Data
public class CalculateTaxResultRequest extends BaseRequest {

    private static final long serialVersionUID = -5787395173598333608L;

    /**
     * 综合所得
     */
    @JsonProperty("zhsd")
    private ComplexIncomeResultRequest complexIncomeResultRequest;

    /**
     * 分类所得
     */
    @JsonProperty("flsd")
    private ClassificationIncomeResultRequest classificationIncomeResultRequest;

    /**
     * 非居民所得
     */
    @JsonProperty("fjmsd")
    private NonResidentsIncomeResultRequest nonResidentsIncomeRequest;

    /**
     * 限售股所得
     */
    @JsonProperty("xsgsd")
    private RestrictedStockIncomeResult restrictedStockIncomeResult;

    /**
     * 人员申报失败列表
     */
    @JsonProperty("rysbsblb")
    private List<EmployeeDeclareFeedback> employeeDeclareFeedbackList;
}
