package cn.com.servyou.dto.tax;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

/**
 * @author ranjh
 * @since 20240524
 */
@Data
public class CalculateTaxWithoutRequestIdResult {

    /**
     * 税号
     */
    @JsonProperty("nsrsbh")
    private String taxNo;

    /**
     * 登记序号
     */
    @JsonProperty("djxhid")
    private String registrationNumber;

    /**
     * 企业名称
     */
    @JsonProperty("qymc")
    private String name;

    /**
     * 部门编号
     */
    @JsonProperty("bmbh")
    private String deptNo;

    /**
     * 部门名称
     */
    @JsonProperty("bmmc")
    private String deptName;

    /**
     * 税款所属期
     */
    @JsonProperty("skssq")
    private String period;

    /**
     * 批次号
     */
    @JsonProperty("pch")
    private Integer batchNo;

    /**
     * 薪金类型
     */
    @JsonProperty("xjlx")
    private String salaryType;

    /**
     * 反馈类型
     * detail : 明细，按照批次号类
     * summary : 统计，按照汇总查询
     */
    @JsonProperty("cxlx")
    private String queryType;

    /**
     * 证件类型
     */
    @JsonProperty("zzlx")
    private String licenseType;

    /**
     * 证件号码
     */
    @JsonProperty("zzhm")
    private String licenseNumber;

    /**
     * 页码
     */
    @JsonProperty("pageNo")
    private Integer pageNo;

    /**
     * 每页数量
     */
    @JsonProperty("pageSize")
    private Integer pageSize;

    /**
     * 总条数
     */
    @JsonProperty("total")
    private Integer total;

    /**
     * 数量统计
     */
    @JsonProperty("count")
    private Integer count;

    /**
     * 算税结果
     */
    @JsonProperty("ssjg")
    private List<ComplexIncomeVO> complexIncomeVOList;

    /**
     * 导入标题
     */
    @JsonProperty("drbt")
    private List<String> headList;
}
