package cn.com.servyou.dto.tax;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author pez1420@gmail.com
 * @version $Id: CheckTaxCalResult.java v 0.1 2018/12/12 7:45 PM pez1420 Exp $$
 */
@Data
public class CheckTaxCalResult implements Serializable {

    private static final long serialVersionUID = -2661647695250463818L;

    /**
     * 业务Id， PTS平台传过来的值 返回
     */
    private Integer Id;

    /**
     * 人员id
     */
    @JsonProperty("ygid")
    private Long employeeId;

    /**
     * 人员名称
     */
    @JsonProperty("xm")
    private String employeeName;

    /**
     * 证照类型名称
     */
    @JsonProperty("zzlx")
    protected String licenseType;

    /**
     * 证照号码
     */
    @JsonProperty("zzhm")
    protected String licenseNumber;

    /**
     * 错误码
     */
    @JsonProperty("cwm")
    private String errorCode;

    /**
     * 错误信息
     */
    @JsonProperty("cwxx")
    private String errorMessage;

    /**
     * 所得税表的code
     */
    @JsonProperty("sdxmdm")
    private String incomeItemCode;

    /**
     * 所得税表的name
     */
    @JsonProperty("sdxmmc")
    private String incomeItemName;

}
