package cn.com.servyou.dto.tax;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 分类计算结果
 *
 * @author pez1420@gmail.com
 * @version $Id: ClassificationCalculateResult.java v 0.1 2018/12/14 1:42 AM pez1420 Exp $$
 */
@Data
public class ClassificationCalculateResult implements Serializable {

    private static final long serialVersionUID = 2744275214993303586L;

    /**
     * 分类算税成功列表
     */
    @JsonProperty("sscglb")
    private List<ClassificationIncome> successClassificationIncomes;

    /**
     * 分类算税失败薪资列表
     */
    @JsonProperty("sssblb")
    private List<ClassificationIncome> failedClassificationIncomes;

    /**
     * 分类-失败算税原因列表
     */
    @JsonProperty("sssbyylb")
    private List<CheckTaxCalResult> failedCheckTaxCalResult;

    /**
     * 算税总人数
     */
    @JsonProperty("sszrs")
    private Integer totalPeople;

    /**
     * 算税失败人数
     */
    @JsonProperty("sssbrs")
    private Integer failedPeople;

}
