package cn.com.servyou.dto.tax;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 分类所得
 *
 * @author zhouww
 * @version 20191016
 */
@Data
public class ClassificationIncome extends BaseEmp {

    private static final long serialVersionUID = 6879332430059691578L;

    /**
     * 是否明细申报
     */
    @JsonProperty("sfmxsb")
    private String isDetailedDeclaration;

    /**
     * 所属期
     */
    @JsonProperty("skssq")
    private String period;

    /**
     * 收入额
     */
    @JsonProperty("sre")
    private BigDecimal income;

    /**
     * 免税收入
     */
    @JsonProperty("mssd")
    private BigDecimal exemptIncome;

    /**
     * 财产原值
     */

    @JsonProperty("ccyz")
    private BigDecimal propertyValue;

    /**
     * 允许扣除的税费
     */
    @JsonProperty("yxkcsf")
    private BigDecimal taxDeductible;

    /**
     * 投资抵扣
     */
    @JsonProperty("tzdk")
    private BigDecimal investmentDeduction;

    /**
     * 其他金额
     */
    @JsonProperty("qt")
    private BigDecimal other;

    /**
     * 备注
     */
    @JsonProperty("bz")
    private String remark;

    /**
     * 减除费用
     */
    @JsonProperty("jcfy")
    private BigDecimal deductionAmount;

    /**
     * 减计比例
     */
    @JsonProperty("jjbl")
    private BigDecimal reductionRatio;

    //    /**
    //     * 实际捐赠额
    //     */
    //    @JsonProperty("sjjze")
    //    private BigDecimal actualDonation;
    //
    //    /**
    //     * 捐赠方式
    //     */
    //    @JsonProperty("jzlx")
    //    private String donationType;

    /**
     * 准予扣除的捐赠额
     */
    @JsonProperty("zykcjze")
    private BigDecimal deductibleDonation;

    /**
     * 税前扣除项目合计
     */
    @JsonProperty("sqkcxmhj")
    private BigDecimal pretaxDeductionSum;

    /**
     * 应纳税所得额
     */
    @JsonProperty("ynssde")
    private BigDecimal taxableIncome;

    /**
     * 应纳税额
     */
    @JsonProperty("ynse")
    private BigDecimal payableAmount;

    /**
     * 减免税额
     */
    @JsonProperty("jmse")
    private BigDecimal taxDeduction;

    /**
     * 已缴税额
     */
    @JsonProperty("ykjse")
    private BigDecimal paidAmount;

    /**
     * 应扣缴税额
     */
    @JsonProperty("yingkjse")
    private BigDecimal withholdingAmount;

    /**
     * 税率
     */
    @JsonProperty("sl")
    private BigDecimal taxRate;

    /**
     * 速算扣除数
     */
    @JsonProperty("sskcs")
    private BigDecimal quickDeduction;

    /**
     * 应补退税额
     */
    @JsonProperty("ybtse")
    private BigDecimal refundTax;

    /**
     * 所得项目代码
     */
    @JsonProperty("sdxmda")
    private String incomeItemCode;

    /**
     * 分类所得薪金类别-利息股息红利，股权转让所得，其他财产转让所得，偶然所得，其他所得
     */
    @JsonProperty("sdxm")
    private String incomeItemName;

    /**
     * 所得期间起
     */
    @JsonProperty("sdqjq")
    private String incomePeriodStart;

    /**
     * 所得期间止
     */
    @JsonProperty("sdqjz")
    private String incomePeriodEnd;

    /**
     * 更正标志
     * 默认正常申报0, 更正1
     */
    @JsonProperty("gzbz")
    private String backupType;

    /**
     * 行权收入
     */
    @JsonProperty("xqsr")
    private BigDecimal exerciseIncome;

    /**
     * 本年累计行权收入
     */
    @JsonProperty("ljxqsr")
    private BigDecimal accumulatedExerciseIncome;

    /**
     * 被投资企业所在省（市）代码
     */
    @JsonProperty("btzqyszsdm")
    private String areaCode;

    /**
     * 被投资企业登记序号
     */
    @JsonProperty("btzqydjxh")
    private String registrationNumber;

    /**
     * 被投资企业统一社会信用代码
     */
    @JsonProperty("btzqyshxydm")
    private String taxNo;

    /**
     * 被投资企业名称
     */
    @JsonProperty("btzqymc")
    private String companyName;

    /**
     * 股权转让时间
     */
    @JsonProperty("gqzrsj")
    private String equityTransferDate;
}
