package cn.com.servyou.dto.tax;

import cn.com.servyou.dto.tax.deduction.DeductibleDonation;
import cn.com.servyou.dto.tax.deduction.StockholderEquityTransferRequestVO;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

/**
 * @author zhouww
 * @version 20191016
 */
@Data
public class ClassificationIncomeRequest extends BaseIncomeRequest {

    private static final long serialVersionUID = -2909930278313580296L;

    /**
     * 利息股息红利所得列表
     */
    @JsonProperty("lxgxhllb")
    private List<ClassificationIncome> interestDividendBonusIncomes;

    /**
     * 股权转让所得列表
     */
    @JsonProperty("gqzrlb")
    private List<ClassificationIncome> equitytTransferIncomes;

    /**
     * 其他财产转让所得列表
     */
    @JsonProperty("qtcczrlb")
    private List<ClassificationIncome> otherPropertyAssignmentIncomes;

    /**
     * 其他财产租赁所得列表
     */
    @JsonProperty("qtcczllb")
    private List<ClassificationIncome> otherPropertyRentalIncomes;

    /**
     * 偶然所得列表
     */
    @JsonProperty("orsdlb")
    private List<ClassificationIncome> accidentalIncome;

    /**
     * 个人房屋出租所得列表
     */
    @JsonProperty("grfwczsdlb")
    private List<ClassificationIncome> housingRentIncomes;

    /**
     * 上市公司股息红利所得（沪市、深市、创业板）
     */
    @JsonProperty("ssgsgxhllb")
    private List<ClassificationIncome> listedCompanyInterest;

    /**
     * 随机赠送礼品列表
     */
    @JsonProperty("sjzslplb")
    private List<ClassificationIncome> randomGiveGiftIncomes;

    /**
     * 减免附表列表
     */
    @JsonProperty("jmfblb")
    private List<IncomeDeduction> incomeDeductionList;

    /**
     * 免税附表列表
     */
    @JsonProperty("msfblb")
    private List<ExemptIncome> exemptIncomeList;

    /**
     * 准予扣除的捐赠额附表
     */
    @JsonProperty("zykcjzefb")
    private List<DeductibleDonation> deductibleDonationIncomeList;

    /**
     * 三板市场股息红利所得
     */
    @JsonProperty("sbscgxhllb")
    private List<ClassificationIncome> thirdBoardMarketInterestIncomeList;

    /**
     * 证劵资金利息所得
     */
    @JsonProperty("zjzjlxlb")
    private List<ClassificationIncome> securitiesFundsInterestIncomeList;

    /**
     * 股东股权转让附表
     */
    @JsonProperty("gdgqzrfb")
    private List<StockholderEquityTransferRequestVO> stockholderEquityTransferRequestList;
}
