package cn.com.servyou.dto.tax;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author pez1420@gmail.com
 * @version $ID: ClassificationIncomeResultRequest.java v 0.1 2018/12/14 1:29 AM pez1420 Exp $$
 */
@Data
public class ClassificationIncomeResultRequest implements Serializable {

    private static final long serialVersionUID = 5309167491409590909L;

    /**
     * 利息股息红利所得列表
     */
    @JsonProperty("lxgxhllb")
    private ClassificationCalculateResult interestDividendBonusIncomes;

    /**
     * 股权转让所得列表
     */
    @JsonProperty("gqzrlb")
    private ClassificationCalculateResult equitytTransferIncomes;

    /**
     * 其他财产转让所得列表
     */
    @JsonProperty("qtcczrlb")
    private ClassificationCalculateResult otherPropertyAssignmentIncomes;

    /**
     * 其他财产租赁所得列表
     */
    @JsonProperty("qtcczllb")
    private ClassificationCalculateResult otherPropertyRentalIncomes;

    /**
     * 偶然所得列表
     */
    @JsonProperty("orsdlb")
    private ClassificationCalculateResult accidentalIncome;

    /**
     * 上市公司股息红利所得（沪市、深市、创业板）
     */
    @JsonProperty("ssgsgxhllb")
    private ClassificationCalculateResult listedCompanyInterest;

    /**
     * 个人房屋出租所得列表
     */
    @JsonProperty("grfwczsdlb")
    private ClassificationCalculateResult housingRentIncomes;

    /**
     * 随机赠送礼品所得
     */
    @JsonProperty("sjzslplb")
    private ClassificationCalculateResult randomGiveGiftIncomes;

    /**
     * 三板市场股息红利所得
     */
    @JsonProperty("sbscgxhllb")
    private ClassificationCalculateResult thirdBoardMarketInterestIncomeResult;

    /**
     * 证劵资金利息所得
     */
    @JsonProperty("zjzjlxlb")
    private ClassificationCalculateResult securitiesFundsInterestIncomeResult;
}
