package cn.com.servyou.dto.tax;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author zhouww
 * @version 20191016
 */
@Data
public class ClearDataCondition implements Serializable {

    private static final long serialVersionUID = 7050118629201470470L;

    /**
     * 批次号值1、2、3、4等，如果批次号设置为1则清空从1开始的所有批次数据；
     * 如果批次号设置为2则清空从2开始的所有批次数据
     */
    @JsonProperty("pch")
    private Integer batchNo;

    /**
     * 如果rylb为空，则按照批次号清空薪金数据；
     * 如果rylb传了数据，则只会清空某个批次号下的rylb对应的员工数据
     */
    @JsonProperty("rylb")
    private List<BaseEmployee> companyEmployeeList;

    /**
     * 算薪类型
     *
     * @Description 可填写【正常工资薪金】
     * 【其他连续性劳务报酬】
     * 【保险营销员佣金收入】
     * 【证券经纪人佣金收入】
     * 【全年一次性奖金】
     * 不填则清除【正常工资薪金】数据
     */
    @JsonProperty("sxlx")
    private String salaryType;
}
