package cn.com.servyou.dto.tax;

import cn.com.servyou.dto.employee.CompanyDetailEmployee;
import cn.com.servyou.dto.enums.DeclareEmployeeStrategy;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author zhouww
 * @version $Id: CompanyEmployee.java v 0.1 2018/11/29 下午8:29 YuJiaqi Exp $$
 */
@Data
public class CompanyEmployee extends CompanyDetailEmployee {

    private static final long serialVersionUID = -6217793890310027617L;

    /**
     * 工号
     */
    @JsonProperty("gh")
    private String employeeNumber;

    /**
     * 所属期
     */
    @JsonProperty("skssq")
    private String period;

    /**
     * 手机号码
     */
    @JsonProperty("lxdh")
    private String phone;

    /**
     * 人员状态
     */
    @JsonProperty("nsrzt")
    private String state;

    /**
     * 是否雇员
     */
    @JsonProperty("sfgy")
    private String isEmployee;

    /**
     * 入职年度就业情况
     */
    @JsonProperty("rzndjyqk")
    private String firstEmploymentSituation;

    /**
     * 受雇日期
     */
    @JsonProperty("rzsgrq")
    private String employedDate;

    /**
     * 性别
     */
    @JsonProperty("xb")
    private String gender;

    /**
     * 出生日期
     */
    @JsonProperty("csny")
    private String birthday;

    /**
     * 国籍
     */
    @JsonProperty("gj")
    private String nationality;

    /**
     * 人员地区
     */
    @JsonProperty("rydq")
    private String area;

    /**
     * 离职日期
     */
    @JsonProperty("lzrq")
    private String resignDate;

    /**
     * 个人投资总额
     */
    @JsonProperty("grgbze")
    private BigDecimal personInvestment;

    /**
     * 个人投资比例
     */
    @JsonProperty("grgbbl")
    private BigDecimal personInvestmentRatio;

    /**
     * 是否残疾
     */
    @JsonProperty("sfcj")
    private String isDisabled;

    /**
     * 残疾证件类型
     *
     * @Description 当为残疾时必填，可选证件类型包括：“残疾证”、“残疾军人证”、“伤残人民警察证”、“残疾消防救援人员证”、“伤残预备役人员”、“伤残民兵民工证”、“因公伤残人员证”
     */
    @JsonProperty("cjzjlx")
    private String disableCardTypeName;

    /**
     * 是否烈属
     */
    @JsonProperty("sfls")
    private String isMartyr;

    /**
     * 是否孤老
     */
    @JsonProperty("sfgl")
    private String isBereavedGaffer;

    /**
     * 残疾证号
     */
    @JsonProperty("cjzh")
    private String disableCardNumber;

    /**
     * 烈属证号
     */
    @JsonProperty("lszh")
    private String martyrCardNumber;

    /**
     * 电子邮箱
     */
    @JsonProperty("dzyx")
    private String email;

    /**
     * 学历
     */
    @JsonProperty("xl")
    private String education;

    /**
     * 职务
     */
    @JsonProperty("zw")
    private String position;

    /**
     * 开户银行
     */
    @JsonProperty("khyh")
    private String depositBank;

    /**
     * 开户银行省份(名字)
     */
    @JsonProperty("khyhsfmz")
    private String depositBankProvinceName;

    /**
     * 银行账号
     */
    @JsonProperty("yhzh")
    private String bankAccount;

    /**
     * 居住省份
     */
    @JsonProperty("lxdz_sheng")
    private String residentProvince;

    /**
     * 居住城市
     */
    @JsonProperty("lxdz_shi")
    private String residentCity;

    /**
     * 居住区县
     */
    @JsonProperty("lxdz_qx")
    private String residentDistrict;

    /**
     * 居住街道
     */
    @JsonProperty("lxdz_jd")
    private String residentStreet;

    /**
     * 居住详细地址
     */
    @JsonProperty("lxdz")
    private String residentAddress;

    /**
     * 户籍省份
     */
    @JsonProperty("hjszd_sheng")
    private String censusProvince;

    /**
     * 户籍城市
     */
    @JsonProperty("hjszd_shi")
    private String censusCity;

    /**
     * 户籍区县
     */
    @JsonProperty("hjszd_qx")
    private String censusDistrict;

    /**
     * 户籍街道
     */
    @JsonProperty("hjszd_jd")
    private String censusStreet;

    /**
     * 户籍详细地址
     */
    @JsonProperty("hjszd_xxdz")
    private String censusAddress;

    /**
     * 备注
     */
    @JsonProperty("bz")
    private String empRemark;

    //境外人员字段

    /**
     * 出生地
     */
    @JsonProperty("csd")
    private String birthplace;

    /**
     * 首次入境时间
     */
    @JsonProperty("scrjsj")
    private String firstEntryDate;

    /**
     * 预计离境时间
     */
    @JsonProperty("yjljsj")
    private String estimatedDepartureDate;

    /**
     * 联系地省份
     */
    @JsonProperty("wjrlxdz_sheng")
    private String contactProvince;

    /**
     * 联系地城市
     */
    @JsonProperty("wjrlxdz_shi")
    private String contactCity;

    /**
     * 联系地区县
     */
    @JsonProperty("wjrlxdz_qx")
    private String contactDistrict;

    /**
     * 联系地街道
     */
    @JsonProperty("wjrlxdz_jd")
    private String contactStreet;

    /**
     * 联系地详细地址
     */
    @JsonProperty("wjrlxdz_xxdz")
    private String contactAddress;

    /**
     * 中文名
     */
    @JsonProperty("xmzw")
    private String chineseName;

    /**
     * 其他证照号码
     */
    @JsonProperty("qtzzhm")
    private String otherLicenseNumber;

    /**
     * 其他证照类型name
     */
    @JsonProperty("qtzzlx")
    private String otherLicenseType;

    /**
     * 涉税事项
     */
    @JsonProperty("sssx")
    private String taxRelatedReason;

    /**
     * 是否扣除减除费用（原是否主单位）
     *
     * @Description 默认为是，可选择是/否
     */
    @JsonProperty("sfzdw")
    private String isMainUnits;

    /**
     * 人员申报策略
     *
     * @Description 1. 默认逻辑“是”，仅当信息变化时才会报送信息到税局
     * 2. 若企业想要支持人员信息不变化的情况下，也能重新发起报送，覆盖局端信息，可修改传参为“否”
     */
    @JsonProperty("rybscl")
    private String declareEmployeeStrategy = DeclareEmployeeStrategy.YES.getCode();

    /**
     * 是否已建档
     *
     * @Description 返回是/否
     * 如果存在自然人档案号则返回是，反之则返回否
     */
    @JsonProperty("sfyjd")
    private String archiveState;
}
